//
//  UITraitCollection+SwiftUI.swift
//  Do It
//
//  Created by Jim Dovey on 10/23/19.
//  Copyright © 2019 Jim Dovey. All rights reserved.
//

import UIKit
import SwiftUI

extension UIContentSizeCategory {
    init(_ swiftuiValue: ContentSizeCategory) {
        switch swiftuiValue {
        case .extraSmall:
            self = .extraSmall
        case .small:
            self = .small
        case .medium:
            self = .medium
        case .large:
            self = .large
        case .extraLarge:
            self = .extraLarge
        case .extraExtraLarge:
            self = .extraExtraLarge
        case .extraExtraExtraLarge:
            self = .extraExtraExtraLarge
        case .accessibilityMedium:
            self = .accessibilityMedium
        case .accessibilityLarge:
            self = .accessibilityLarge
        case .accessibilityExtraLarge:
            self = .accessibilityExtraLarge
        case .accessibilityExtraExtraLarge:
            self = .accessibilityExtraExtraLarge
        case .accessibilityExtraExtraExtraLarge:
            self = .accessibilityExtraExtraExtraLarge
        @unknown default:
            self = .unspecified
        }
    }
}

extension UITraitCollection {
    convenience init(swiftUIContentSizeCategory value: ContentSizeCategory) {
        self.init(preferredContentSizeCategory: UIContentSizeCategory(value))
    }
}
